// priority: 100
onEvent('chest.loot_tables', event => {
    var addMysticalActivatorToChestPool = function (name, chance) {
        event.modify(name, table => {
            table.addPool(pool => {
                pool.rolls = 1
                pool.addCondition({
                    'condition': 'minecraft:random_chance',
                    'chance': chance
                })
                pool.addEntry({
                    'type': 'minecraft:item',
                    'name': 'kubejsadditions:mystical_activator_substance'
                })
            })
        })
    }

    var lootTables = [
        'minecraft:abandoned_mineshaft',
        'minecraft:bastion_bridge',
        'minecraft:bastion_hoglin_stable',
        'minecraft:bastion_other',
        'minecraft:bastion_treasure',
        'minecraft:buried_treasure',
        'minecraft:desert_pyramid',
        'minecraft:end_city_treasure',
        'minecraft:igloo_chest',
        'minecraft:jungle_temple',
        'minecraft:jungle_temple_dispenser',
        'minecraft:nether_bridge',
        'minecraft:pillager_outpost',
        'minecraft:ruined_portal',
        'minecraft:shipwreck_map',
        'minecraft:shipwreck_supply',
        'minecraft:shipwreck_treasure',
        'minecraft:simple_dungeon',
        'minecraft:stronghold_corridor',
        'minecraft:stronghold_crossing',
        'minecraft:stronghold_library',
        'minecraft:underwater_ruin_big',
        'minecraft:underwater_ruin_small',
        'minecraft:village/village_armorer',
        'minecraft:village/village_butcher',
        'minecraft:village/village_cartographer',
        'minecraft:village/village_desert_house',
        'minecraft:village/village_fisher',
        'minecraft:village/village_fletcher',
        'minecraft:village/village_mason',
        'minecraft:village/village_plains_house',
        'minecraft:village/village_savanna_house',
        'minecraft:village/village_shepherd',
        'minecraft:village/village_snowy_house',
        'minecraft:village/village_taiga_house',
        'minecraft:village/village_tannery',
        'minecraft:village/village_temple',
        'minecraft:village/village_toolsmith',
        'minecraft:village/village_weaponsmith',
        'minecraft:village/village_shepherd',
        'minecraft:woodland_mansion',
        'ae2:meteorite',
        'immersiveengineering:engineers_house'
    ];

    //Add the Mystical Activator Substance a 16% chance in every single chest that can be found.
    lootTables.forEach((table) => {
        addMysticalActivatorToChestPool(table, 0.16)
    });
})

//The use for the Mystical Activator Substance and other custom stuff
onEvent('recipes', (event) => {
    global.seedTiers.forEach((tier) => {
        tier.seeds.forEach((seed) => {
            event.shapeless('2x mysticalagriculture:' + seed + '_seeds',
                ['mysticalagriculture:' + seed + '_seeds', 'kubejsadditions:mystical_activator_substance']);
        })
    })

    //Recipes for progression to Mystical Activator Substance
    //Tablet of Overgrown Fertility
    event.shaped('kubejsadditions:tablet_of_overgrown_fertility', [' B ', 'ATC', ' D '], {
        T: 'ars_nouveau:ritual_fertility',
        A: 'mysticalagriculture:mystical_fertilizer',
        B: 'botania:fertilizer',
        C: 'thermal:phytogro',
        D: 'create:tree_fertilizer',
    });
    //Life Infusing Kit
    event.custom({
        type: 'botania:mana_infusion',
        input: {
            item: 'kubejsadditions:tablet_of_overgrown_fertility'
        },
        output: {
            item: 'kubejsadditions:life_infusing_kit'
        },
        mana: 500
    });
    //Life Gem
    event.shapeless('kubejsadditions:life_gem', ['kubejsadditions:life_infusing_kit', 'mysticalagriculture:supremium_gemstone']);
    //Life Dust
    global.simpleSingleItemCrushing('kubejsadditions:life_dust', 'kubejsadditions:life_gem', event)
    //Lively Ashes
    event.recipes.minecraft.smelting('kubejsadditions:lively_ashes', 'biomesoplenty:rainbow_birch_sapling').xp(1);
    //Mystical Activator Substance
    event.recipes.createMixing('kubejsadditions:mystical_activator_substance', ['kubejsadditions:life_dust', 'kubejsadditions:lively_ashes', '#forge:dyes/blue'])

    //Dimensional Shard Block
    event.shaped('kubejsadditions:dimensional_shard_block', ['III', 'III', 'III'], {
        I: 'rftoolsbase:dimensionalshard'
    });

    //Recipes for Tesseracted Plexiglass
    //Plexiglass fluid alloying in the Smeltery
    event.custom({
        "type": "tconstruct:alloy",
        "inputs": [
            {
                "name": "immersiveengineering:phenolic_resin",
                "amount": 90
            },
            {
                "name": "mekanism:sodium",
                "amount": 90
            }
        ],
        "result": {
            "fluid": "kubejsadditions:molten_plexiglass",
            "amount": 180
        },
        "temperature": 200
    })

    //Also allow using the Refinery for it
    event.custom({
        type: "immersiveengineering:refinery",
        result: {
            fluid: "kubejsadditions:molten_plexiglass",
            amount: 16
        },
        input0: {
            tag: "immersiveengineering:phenolic_resin",
            amount: 8
        },
        input1: {
            tag: "mekanism:sodium",
            amount: 8
        },
        energy: 100
    })

    //Melting of already existing plexiglass
    event.custom({
        "type": "tconstruct:melting",
        "ingredient": {
            "tag": "kubejsadditions:plexiglass"
        },
        "result": {
            "fluid": "kubejsadditions:molten_plexiglass",
            "amount": 360
        },
        "temperature": 200,
        "time": 16
    })
    event.custom({
        "type": "tconstruct:melting",
        "ingredient": {
            "item": "kubejsadditions:sheet_of_plexiglass"
        },
        "result": {
            "fluid": "kubejsadditions:molten_plexiglass",
            "amount": 90
        },
        "temperature": 200,
        "time": 4
    })

    //Melting in Magma Crucible
    event.recipes.thermal.crucible(Fluid.of('kubejsadditions:molten_plexiglass', 90), 'kubejsadditions:sheet_of_plexiglass')
    event.recipes.thermal.crucible(Fluid.of('kubejsadditions:molten_plexiglass', 360), '#kubejsadditions:plexiglass')

    //Casting Plexiglass into sheet and block
    event.custom({
        "type": "tconstruct:casting_basin",
        "fluid": {
            "name": "kubejsadditions:molten_plexiglass",
            "amount": 360
        },
        "result": "kubejsadditions:clear_plexiglass",
        "cooling_time": 96
    })
    event.custom({
        "type": "tconstruct:casting_table",
        "cast": {
            "tag": "tconstruct:casts/multi_use/plate"
        },
        "fluid": {
            "name": "kubejsadditions:molten_plexiglass",
            "amount": 90
        },
        "result": "kubejsadditions:sheet_of_plexiglass",
        "cooling_time": 24
    })

    //Crafting and uncrafting plexiglass
    event.shaped('kubejsadditions:clear_plexiglass', ['PP', 'PP'], {
        P: 'kubejsadditions:sheet_of_plexiglass'
    });
    event.recipes.immersiveengineeringSawmill('4x kubejsadditions:sheet_of_plexiglass', '#kubejsadditions:plexiglass')
    event.recipes.mekanismSawing('4x kubejsadditions:sheet_of_plexiglass', '#kubejsadditions:plexiglass')
    event.recipes.thermal.sawmill('4x kubejsadditions:sheet_of_plexiglass', '#kubejsadditions:plexiglass')

    //Flask of Plastic Mixture
    event.recipes.createMixing('kubejsadditions:flask_of_plastic_mixture', ['kubejsadditions:sheet_of_plexiglass', 'pneumaticcraft:plastic', 'mekanism:hdpe_sheet', '#forge:dusts/sulfur', 'botania:flask']).heated()

    //Tesseract Frame
    event.custom({
        type: 'malum:block_transmutation',
        input: 'tesseract:tesseract',
        output: 'kubejsadditions:tesseract_frame'
    });

    //Nether Star Shard
    event.recipes.immersiveengineeringSawmill('4x kubejsadditions:nether_star_shard', 'minecraft:nether_star')
    event.recipes.mekanismSawing('4x kubejsadditions:nether_star_shard', 'minecraft:nether_star')
    event.recipes.thermal.sawmill('4x kubejsadditions:nether_star_shard', 'minecraft:nether_star')
    event.shaped('minecraft:nether_star', [' S ', 'SGS', ' S '], {
        S: 'kubejsadditions:nether_star_shard',
        G: '#forge:slimeballs'
    });

    //Metallic Shard
    event.custom({
        "type": "ars_nouveau:imbuement",
        "input": {
            "item": 'kubejsadditions:nether_star_shard'
        },
        "output": 'kubejsadditions:metallic_shard',
        "count": 1,
        "source": 10000,
        "pedestalItems": [
            {
                "item": {
                    "item": 'malum:soul_stained_steel_ingot'
                }
            },
            {
                "item": {
                    "item": 'botania:terrasteel_ingot'
                }
            },
            {
                "item": {
                    "item": 'thermal:enderium_ingot'
                }
            },
            {
                "item": {
                    "item": 'mekanism:ingot_refined_obsidian'
                }
            },
            {
                "item": {
                    "item": 'soulshards:corrupted_ingot'
                }
            }
        ]
    })

    //Half-Heart
    event.shapeless('kubejsadditions:half_heart', ['kubejsadditions:metallic_shard', '#kubejsadditions:heart_fragment']);

    //Bottle of Frosty Confetti
    event.shapeless('kubejsadditions:bottle_of_frosty_confetti', ['minecraft:glass_bottle', 'thermal:blizz_powder', 'hearthstones:deep_blue', 'malum:hex_ash', 'ae2:fluix_dust']);

    //Power Globe
    event.shapeless('kubejsadditions:power_globe', ['kubejsadditions:bottle_of_frosty_confetti', 'kubejsadditions:half_heart', 'thermal:jar']);

    //Tesseracted Plexiglass
    event.custom({
        "type": "ars_nouveau:enchanting_apparatus",
        "reagent": [
            {
                "item": 'kubejsadditions:tesseract_frame'
            }
        ],
        "pedestalItems": [
            {
                "item": {
                    "item": 'kubejsadditions:flask_of_plastic_mixture'
                }
            },
            {
                "item": {
                    "item": 'kubejsadditions:power_globe'
                }
            },
            {
                "item": {
                    "item": 'glowinc:pure_glow_bottle'
                }
            }
        ],
        "output": {
            "item": 'kubejsadditions:tesseracted_plexiglass'
        },
        "sourceCost": 0
    })

    //Colored Plexiglass blocks
    global.dyes.forEach((dye) => {
        event.shaped('8x kubejsadditions:' + dye + '_plexiglass', ['PPP', 'PIP', 'PPP'], {
            P: '#kubejsadditions:plexiglass',
            I: '#forge:dyes/' + dye
        });
    })

    //Buff Pies
    event.shapeless('kubejsadditions:mushroom_pie', ['#forge:mushrooms', 'thermal:cheese_wedge', 'bhc:red_heart']);
    event.shapeless('kubejsadditions:nature_delicacy', ['thermal:green_bean', 'biomesoplenty:watergrass', 'bhc:green_heart']);
    event.shapeless('kubejsadditions:frosty_pudding_pie', ['thermal:frost_melon_slice', 'minecraft:snowball', 'bhc:blue_heart']);
    event.shapeless('kubejsadditions:glowing_pie', ['minecraft:glow_berries', 'minecraft:sugar', 'bhc:yellow_heart']);

    //Popcorn
    event.recipes.minecraft.smelting('kubejsadditions:popcorn', 'thermal:corn_seeds').xp(0.35);
    event.recipes.minecraft.smoking('kubejsadditions:popcorn', 'thermal:corn_seeds').xp(0.35);
    event.recipes.minecraft.campfireCooking('kubejsadditions:popcorn', 'thermal:corn_seeds');
})
